// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/application_setup.mojom
//

package org.chromium.mojom.content;

class ApplicationSetup_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<ApplicationSetup, ApplicationSetup.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<ApplicationSetup, ApplicationSetup.Proxy>() {
    
        public String getName() {
            return "content::ApplicationSetup";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, ApplicationSetup impl) {
            return new Stub(core, impl);
        }
    
        public ApplicationSetup[] buildArray(int size) {
          return new ApplicationSetup[size];
        }
    };

    private static final int EXCHANGE_SERVICE_PROVIDERS_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements ApplicationSetup.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void exchangeServiceProviders(org.chromium.mojo.bindings.InterfaceRequest<org.chromium.mojom.mojo.ServiceProvider> services, org.chromium.mojom.mojo.ServiceProvider exposedServices) {
            ApplicationSetupExchangeServiceProvidersParams _message = new ApplicationSetupExchangeServiceProvidersParams();
            _message.services = services;
            _message.exposedServices = exposedServices;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(EXCHANGE_SERVICE_PROVIDERS_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<ApplicationSetup> {

        Stub(org.chromium.mojo.system.Core core, ApplicationSetup impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ApplicationSetup_Internal.MANAGER, messageWithHeader);
                    case EXCHANGE_SERVICE_PROVIDERS_ORDINAL: {
                        ApplicationSetupExchangeServiceProvidersParams data =
                                ApplicationSetupExchangeServiceProvidersParams.deserialize(messageWithHeader.getPayload());
                        getImpl().exchangeServiceProviders(data.services, data.exposedServices);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ApplicationSetup_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ApplicationSetupExchangeServiceProvidersParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public org.chromium.mojo.bindings.InterfaceRequest<org.chromium.mojom.mojo.ServiceProvider> services;
        public org.chromium.mojom.mojo.ServiceProvider exposedServices;
    
        private ApplicationSetupExchangeServiceProvidersParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ApplicationSetupExchangeServiceProvidersParams() {
            this(0);
        }
    
        public static ApplicationSetupExchangeServiceProvidersParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ApplicationSetupExchangeServiceProvidersParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ApplicationSetupExchangeServiceProvidersParams result = new ApplicationSetupExchangeServiceProvidersParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.services = decoder0.readInterfaceRequest(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.exposedServices = decoder0.readServiceInterface(12, false, org.chromium.mojom.mojo.ServiceProvider.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(services, 8, false);
            encoder0.encode(exposedServices, 12, false, org.chromium.mojom.mojo.ServiceProvider.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ApplicationSetupExchangeServiceProvidersParams other = (ApplicationSetupExchangeServiceProvidersParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.services, other.services))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.exposedServices, other.exposedServices))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(services);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(exposedServices);
            return result;
        }
    }

}

